#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using gov.va.med.vbecs.BOL.UnitTests;

#endregion
namespace gov.va.med.vbecs.VAL.UnitTests
{
	[TestFixture]
	public class VAL_DssExtract : BaseTest 
	{
		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			VistALinkUnitTestHarness.RequireConnection();
		}

		[TearDown]
		protected void TearDown()
		{
			VistALinkUnitTestHarness.ReleaseConnection(); 
		}

		[Test]
		public void GetDssExtractRpcRequest_Pass()
		{
			Guid test1PatientTranfusionGuid = Guid.Empty;
			//
			bool successIndicator = false;
			//
			#region Part I. Send Dss update after patient transfusion update (simulates UC 69)

			// *****************************************************************************************************************
			// Create Issued Unit ( from SprocHelper )
			bool createOrderStatus = true;
			//
			System.Guid patientGuid = DataCreator.GetRecordGuid("SELECT TOP 1 P.PatientGuid FROM Patient P JOIN PatientTreatment PT ON P.PatientGuid = PT.PatientGuid");
			System.Guid ptGuid = DataCreator.GetRecordGuid("SELECT TOP 1 PatientTreatmentGuid FROM PatientTreatment WHERE PatientGuid = '" + patientGuid.ToString() + "'");
			System.Guid bpGuid = DataCreator.GetRecordGuid("SELECT TOP 1 PS.BloodProductGuid FROM ProductShipper PS JOIN BloodProduct BP ON BP.BloodProductGuid = PS.BloodProductGuid WHERE BP.ProductCodeIndicator = 1 AND PS.RecordStatusCode = 'A' AND PS.DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'");
			System.Guid busGuid = System.Guid.NewGuid();
			System.Guid buGuid = System.Guid.NewGuid();
			System.Guid iuGuid = System.Guid.NewGuid();
			System.Guid ouGuid = System.Guid.NewGuid();
			System.Guid ocGuid = System.Guid.NewGuid();
			System.Guid poGuid = System.Guid.NewGuid();
			System.Guid psGuid = System.Guid.NewGuid();
			System.Guid otGuid = System.Guid.NewGuid();
			string specimenUid = DataCreator.GetNewSpecimenUid();

			//Create a unit to Issue  --- Was manullay setting UnitStatusCode to I here... UGH!
			DataCreator.CreateBloodUnit(buGuid, busGuid, System.Guid.Empty, bpGuid, false);

			//Hopefully that worked...
			//Not sure if I need a PatientSpecimen or not, so holding off here....
			System.Collections.ArrayList dtArray = new System.Collections.ArrayList();
			System.Collections.ArrayList spArray = new System.Collections.ArrayList();

			dtArray.Add(SprocHelper.GetInsertPatientSpecimenSprocTable(psGuid, patientGuid, specimenUid));
			spArray.Add(SPROCS.InsertPatientSpecimen.StoredProcName);

			dtArray.Add(SprocHelper.GetInsertPatientOrderSprocTable(poGuid, ptGuid));
			spArray.Add(SPROCS.InsertPatientOrder.StoredProcName);

			dtArray.Add(SprocHelper.GetHL7UpdateOrderedComponent(ocGuid, poGuid, createOrderStatus));
			spArray.Add(SPROCS.HL7UpdateOrderedComponent.StoredProcName);

			dtArray.Add(SprocHelper.GetInsertOrderedUnitSprocTable(ouGuid, ocGuid, buGuid));
			spArray.Add(SPROCS.InsertOrderedUnit.StoredProcName);

			dtArray.Add(SprocHelper.GetInsertIssuedUnitSprocTable(iuGuid, buGuid, patientGuid));
			spArray.Add(SPROCS.InsertIssuedUnit.StoredProcName);

			dtArray.Add(SprocHelper.GetInsertOrderedTestSprocTable(otGuid, poGuid, psGuid));
			spArray.Add(SPROCS.InsertOrderedTest.StoredProcName);

			int retValue = new Common.StoredProcedure().TransactionalGetValue(spArray, dtArray);

			if (retValue != 0)
			{
				throw new BOL.BusinessObjectException("CRAP! THE ISSUE UNIT CREATION FAILED!!!");
			}
			else
			{
				if (createOrderStatus)
				{
					UnitTestUtil.RunSQL("UPDATE OrderedComponent SET TaskStatusCode = 'I' WHERE OrderedComponentGuid = '" + ocGuid.ToString() + "'");
				}
			}
			// *****************************************************************************************************************
			// Create a patient transfusion record
			BOL.PatientTransfusion tstPT = new BOL.PatientTransfusion( patientGuid, buGuid, false );
			tstPT.Transfusionist1Id = "Sanchez";
			tstPT.Transfusionist2Id = "Yoshida";
			tstPT.TransfusionStartDateTime = BOL.VBECSDateTime.GetDivisionCurrentDateTime().AddDays( -1 );
			tstPT.TransfusionEndDateTime = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			tstPT.PatientLocation = tstPT.GetLocations()[0].ToString();
			tstPT.TransfusionInterrupted = true;
			tstPT.TransfusedVolume = 50;
			tstPT.ReactionIndicator = true;
			tstPT.ReactionSymptoms = "Apparent Anaphylaxis";
			tstPT.Comments = string.Concat( "Patient is ok, but there are apparent reaction indicators. ", DateTime.UtcNow.ToLongTimeString() );
			tstPT.ApplicationOfRecordId = Common.Utility.GetApplicationOfRecordTypeIntegerValue( Common.ApplicationOfRecordType.VBECS );
			//
			test1PatientTranfusionGuid = tstPT.PatientTransfusionGuid;
			Assert.IsTrue( test1PatientTranfusionGuid != Guid.Empty );
			//
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.TransfuseUnit);
			successIndicator = tstPT.Save( Common.WorkloadProcessID.TransfuseUnit );
			Assert.IsTrue( successIndicator );
			//
			// *****************************************************************************************************************
			// Ok, now send the data to Dss
			successIndicator = DAL.VAL.DssExtract.UpdateVistADssExtract( tstPT.PatientTransfusionGuid, COMMON.UpdateFunction.UnitTests );
			Assert.IsTrue( successIndicator );
			//
			// *****************************************************************************************************************

			#endregion
			//
			#region Part II. Send Dss update after patient transfusion reaction finalization (simulates UC 78)

			// This is borrowed from UnitTest\BOL\PatientTransfusionReaction.SaveImplicatedBloodUnits_Pass
			//
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			System.Guid bloodUnitGuid = System.Guid.NewGuid();
			System.Guid bloodProductGuid = (System.Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, System.Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);

			// Insert an RBCx2 order and a TRW order, then transfuse 1 unit...
			Guid patientTreatmentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid prePatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(prePatientSpecimenGuid, patientGuid, true);

			Guid postPatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(postPatientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedTest(orderedTestGuid, patientOrderGuid, postPatientSpecimenGuid, Common.OrderableTest.TRW);

			Guid orderedComponentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);

			Guid orderedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid1, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid2, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");

			Guid issuedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertIssuedUnit(issuedUnitGuid, bloodUnitGuid);

			Guid patientTransfusionGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTransfusion(patientTransfusionGuid, patientGuid, bloodUnitGuid);

			//
			//Now we can enter all phases of a TRW...
			ArrayList bloodUnitTests = new ArrayList();
			ArrayList postSpecimenTests = new ArrayList();
			ArrayList preSpecimenTests = new ArrayList();

			BOL.PatientTransfusionReaction ptr = new BOL.PatientTransfusionReaction(orderedTestGuid);
			BOL.OrderedTest orderedTest = new BOL.OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			ptr.PatientGuid = patientGuid;
			ptr.NotedDateTime = DateTime.Now;
			ptr.InvestigatedDateTime = DateTime.Now;
			ptr.PreSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			ptr.PostSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			BOL.Specimen preSpecimen = new BOL.Specimen(prePatientSpecimenGuid);
			preSpecimen.PostTransfusionIndicator = false;
			ptr.PreSpecimenHemolysisInspectionCode = "1";
			BOL.Specimen postSpecimen = new BOL.Specimen(postPatientSpecimenGuid);
			postSpecimen.PostTransfusionIndicator = true;
			ptr.PostSpecimenHemolysisInspectionCode = "1";
			//
			ptr.PreSpecimenGuid = preSpecimen.SpecimenGuid;
			ptr.PostSpecimenGuid = postSpecimen.SpecimenGuid;
			orderedTest.Specimen = postSpecimen;
			ArrayList specimens = new ArrayList(2);
			specimens.Add(preSpecimen);
			specimens.Add(postSpecimen);
			//
			ptr.SaveSpecimenCheckData(orderedTest, new ArrayList(), null);
			//
			ptr = new BOL.PatientTransfusionReaction(orderedTestGuid);
			BOL.TransfusionReaction transfusionReaction = new BOL.TransfusionReaction();
			transfusionReaction.BagClericalChecksOkIndicator = false;
			transfusionReaction.BagHemolysisInspectionCode = "1";
			transfusionReaction.BagReturnedIndicator = true;
			transfusionReaction.PatientTransfusionGuid = patientTransfusionGuid;
			transfusionReaction.PatientTransfusionReactionGuid = ptr.PatientTransfusionReactionGuid;
			transfusionReaction.TransfusionReactionGuid = Guid.NewGuid();
			ArrayList transfusionReactions = new ArrayList(1);
			transfusionReactions.Add(transfusionReaction);
			//
			// Comments
			ArrayList comments = new ArrayList();
			BOL.PatientTransfusionComment implicatedUnitComment = new BOL.PatientTransfusionComment(Common.PatientTransfusionCommentCategoryCode.ImplicatedUnits);
			implicatedUnitComment.PatientTransfusionReactionGuid = ptr.PatientTransfusionReactionGuid;
			implicatedUnitComment.PatientTransfusionGuid = patientTransfusionGuid;
			implicatedUnitComment.PatientTransfusionCommentText = "Implicated Unit Comment Test";
			implicatedUnitComment.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			implicatedUnitComment.LastUpdateUser = Common.LogonUser.LogonUserName;
			comments.Add(implicatedUnitComment);
			//
			bool success = ptr.SaveImplicatedBloodUnits(transfusionReactions, comments, null);
			Assert.IsTrue(success);
			//
			// *****************************************************************************************************************
			// Ok, now send the data to Dss
			successIndicator = DAL.VAL.DssExtract.UpdateVistADssExtract( patientTransfusionGuid, COMMON.UpdateFunction.UnitTests );
			Assert.IsTrue( successIndicator );
			//
			// *****************************************************************************************************************

			#endregion
			//
			#region Part III. Send Dss updates for all those records which were not successful

			// We will simulate this by changing the PT record's DssExtractSuccessIndicator to '0' from the previous test (Part I.)
			string update = "UPDATE PatientTransfusion SET DssExtractSuccessIndicator = 0 WHERE PatientTransfusionGuid ='";
			update = string.Concat( update, test1PatientTranfusionGuid.ToString(), "'" );
			//
			UnitTestUtil.RunSQL( update );
			//
			successIndicator = DAL.VAL.DssExtract.UpdateVistADssExtract( Guid.Empty, COMMON.UpdateFunction.UnitTests );
			Assert.IsTrue( successIndicator );

			#endregion
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetDssExtractRpcRequest_Fail()
		{
		}

		[Test]
		public void GetPatientTransfusionGuidsForDssExtract_Pass()
		{
			Guid [] ptGuids = DAL.VAL.DssExtract.GetPatientTransfusionGuidsForDssExtract();
			//
			if ( ptGuids == null || ptGuids.Length == 0 )
			{
				#region Create Patient Transfusion data
				
				// *****************************************************************************************************************
				// Create Issued Unit ( from SprocHelper )
				bool createOrderStatus = true;
				//
				System.Guid patientGuid = DataCreator.GetRecordGuid("SELECT TOP 1 P.PatientGuid FROM Patient P JOIN PatientTreatment PT ON P.PatientGuid = PT.PatientGuid");
				System.Guid ptGuid = DataCreator.GetRecordGuid("SELECT TOP 1 PatientTreatmentGuid FROM PatientTreatment WHERE PatientGuid = '" + patientGuid.ToString() + "'");
				System.Guid bpGuid = DataCreator.GetRecordGuid("SELECT TOP 1 PS.BloodProductGuid FROM ProductShipper PS JOIN BloodProduct BP ON BP.BloodProductGuid = PS.BloodProductGuid AND BP.ProductCodeIndicator = 1 WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'");
				System.Guid busGuid = System.Guid.NewGuid();
				System.Guid buGuid = System.Guid.NewGuid();
				System.Guid iuGuid = System.Guid.NewGuid();
				System.Guid ouGuid = System.Guid.NewGuid();
				System.Guid ocGuid = System.Guid.NewGuid();
				System.Guid poGuid = System.Guid.NewGuid();
				System.Guid psGuid = System.Guid.NewGuid();
				System.Guid otGuid = System.Guid.NewGuid();
				string specimenUid = DataCreator.GetNewSpecimenUid();

				//Create a unit to Issue  --- Was manullay setting UnitStatusCode to I here... UGH!
				DataCreator.CreateBloodUnit(buGuid, busGuid, System.Guid.Empty, bpGuid, false);

				//Hopefully that worked...
				//Not sure if I need a PatientSpecimen or not, so holding off here....
				System.Collections.ArrayList dtArray = new System.Collections.ArrayList();
				System.Collections.ArrayList spArray = new System.Collections.ArrayList();

				dtArray.Add(SprocHelper.GetInsertPatientSpecimenSprocTable(psGuid, patientGuid, specimenUid));
				spArray.Add(SPROCS.InsertPatientSpecimen.StoredProcName);

				dtArray.Add(SprocHelper.GetInsertPatientOrderSprocTable(poGuid, ptGuid));
				spArray.Add(SPROCS.InsertPatientOrder.StoredProcName);

				dtArray.Add(SprocHelper.GetHL7UpdateOrderedComponent(ocGuid, poGuid, createOrderStatus));
				spArray.Add(SPROCS.HL7UpdateOrderedComponent.StoredProcName);

				dtArray.Add(SprocHelper.GetInsertOrderedUnitSprocTable(ouGuid, ocGuid, buGuid));
				spArray.Add(SPROCS.InsertOrderedUnit.StoredProcName);

				dtArray.Add(SprocHelper.GetInsertIssuedUnitSprocTable(iuGuid, buGuid, patientGuid));
				spArray.Add(SPROCS.InsertIssuedUnit.StoredProcName);

				dtArray.Add(SprocHelper.GetInsertOrderedTestSprocTable(otGuid, poGuid, psGuid));
				spArray.Add(SPROCS.InsertOrderedTest.StoredProcName);

				int retValue = new Common.StoredProcedure().TransactionalGetValue(spArray, dtArray);

				if (retValue != 0)
				{
					throw new BOL.BusinessObjectException("CRAP! THE ISSUE UNIT CREATION FAILED!!!");
				}
				else
				{
					if (createOrderStatus)
					{
						UnitTestUtil.RunSQL("UPDATE OrderedComponent SET TaskStatusCode = 'I' WHERE OrderedComponentGuid = '" + ocGuid.ToString() + "'");
					}
				}
				// *****************************************************************************************************************
				// Create a patient transfusion record
				BOL.PatientTransfusion tstPT = new BOL.PatientTransfusion( patientGuid, buGuid, false );
				tstPT.Transfusionist1Id = "Sanchez";
				tstPT.Transfusionist2Id = "Yoshida";
				tstPT.TransfusionStartDateTime = BOL.VBECSDateTime.GetDivisionCurrentDateTime().AddDays( -1 );
				tstPT.TransfusionEndDateTime = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
				tstPT.PatientLocation = tstPT.GetLocations()[0].ToString();
				tstPT.TransfusionInterrupted = true;
				tstPT.TransfusedVolume = 50;
				tstPT.ReactionIndicator = true;
				tstPT.ReactionSymptoms = "Apparent Anaphylaxis";
				tstPT.Comments = string.Concat( "Patient is ok, but there are apparent reaction indicators. ", DateTime.UtcNow.ToLongTimeString() );
				//
				DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.TransfuseUnit);
				bool successIndicator = tstPT.Save( Common.WorkloadProcessID.TransfuseUnit );
				Assert.IsTrue( successIndicator );
				
				#endregion
				//
				// Ok, now verify we have at least one record ready to be sent to Dss Extract
				ptGuids = DAL.VAL.DssExtract.GetPatientTransfusionGuidsForDssExtract();
			}
			//
			Assert.IsTrue( ptGuids != null || ptGuids.Length > 0 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetPatientTransfusionGuidsForDssExtract_Fail()
		{
		}
	}
}
#endif
